<?php

namespace app\Models\Tenants;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Organization extends Model 
{

    protected $table = 'organizations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id');
    protected $visible = array('user_id');

    public function user()
    {
        return $this->hasOne('App\User', 'user_id');
    }

}